<?php
header('Content-Type: application/json');

// Get POST data
$data = json_decode(file_get_contents('php://input'), true);

// Support both old format (to, message) and new format (sender_number, recipient_number, message)
$senderNumber = $data['sender_number'] ?? '';
$recipientNumber = $data['recipient_number'] ?? $data['to'] ?? '';
$message = $data['message'] ?? '';

if (!$recipientNumber || !$message) {
    echo json_encode(['success' => false, 'error' => 'Missing recipient number or message']);
    exit;
}

// Clean phone number (remove + and spaces)
$recipientNumber = preg_replace('/[^0-9]/', '', $recipientNumber);

// TODO: Integrate with WhatsApp API provider here
// For now, just mock a successful response
$response = [
    'success' => true,
    'sender_number' => $senderNumber,
    'recipient_number' => $recipientNumber,
    'message' => $message,
    'info' => 'This is a mock response. Integrate with your WhatsApp provider (e.g., Twilio, MessageBird, etc.)'
];

// Log the WhatsApp send attempt
error_log("WhatsApp send attempt - From: $senderNumber, To: $recipientNumber, Message: " . substr($message, 0, 100) . '...');

echo json_encode($response); 